<?php

/**
 * Unit test class for the ClassDeclaration sniff.
 *
 * @author    Greg Sherwood <gsherwood@squiz.net>
 * @copyright 2006-2015 Squiz Pty Ltd (ABN 77 084 670 600)
 * @license   https://github.com/squizlabs/PHP_CodeSniffer/blob/master/licence.txt BSD Licence
 */
namespace PHP_CodeSniffer\Standards\PEAR\Tests\Classes;

use PHP_CodeSniffer\Tests\Standards\AbstractSniffUnitTest;
class ClassDeclarationUnitTest extends AbstractSniffUnitTest
{
    /**
     * Get a list of CLI values to set before the file is tested.
     *
     * @param string                  $testFile The name of the file being tested.
     * @param \PHP_CodeSniffer\Config $config   The config data for the test run.
     *
     * @return void
     */
    public function setCliValues($testFile, $config)
    {
        if ($testFile === 'ClassDeclarationUnitTest.1.inc') {
            return;
        }
        $config->tabWidth = 4;
    }
    //end setCliValues()
    /**
     * Returns the lines where errors should occur.
     *
     * The key of the array should represent the line number and the value
     * should represent the number of errors that should occur on that line.
     *
     * @param string $testFile The name of the file being tested.
     *
     * @return array<int, int>
     */
    public function getErrorList($testFile = '')
    {
        switch ($testFile) {
            case 'ClassDeclarationUnitTest.1.inc':
                return [21 => 1, 22 => 1, 23 => 1, 27 => 1, 33 => 1, 38 => 1, 49 => 1, 84 => 1, 94 => 1, 99 => 1, 104 => 1, 110 => 1, 114 => 1];
            default:
                return [];
        }
        //end switch
    }
    //end getErrorList()
    /**
     * Returns the lines where warnings should occur.
     *
     * The key of the array should represent the line number and the value
     * should represent the number of warnings that should occur on that line.
     *
     * @param string $testFile The name of the file being tested.
     *
     * @return array<int, int>
     */
    public function getWarningList($testFile = '')
    {
        if ($testFile === 'ClassDeclarationUnitTest.2.inc') {
            return [11 => 1];
        }
        return [];
    }
    //end getWarningList()
}
//end class
