<?php

/**
 * A filter to only include files that have been staged for commit in a Git repository.
 *
 * This filter is the ideal companion for your pre-commit git hook.
 *
 * @author    Juliette Reinders Folmer <phpcs_nospam@adviesenzo.nl>
 * @copyright 2018 Juliette Reinders Folmer. All rights reserved.
 * @license   https://github.com/squizlabs/PHP_CodeSniffer/blob/master/licence.txt BSD Licence
 */
namespace PHP_CodeSniffer\Filters;

use PHP_CodeSniffer\Util;
class GitStaged extends \PHP_CodeSniffer\Filters\ExactMatch
{
    /**
     * Get a list of blacklisted file paths.
     *
     * @return array
     */
    protected function getBlacklist()
    {
        return [];
    }
    //end getBlacklist()
    /**
     * Get a list of whitelisted file paths.
     *
     * @return array
     */
    protected function getWhitelist()
    {
        $modified = [];
        $cmd = 'git diff --cached --name-only -- ' . \escapeshellarg($this->basedir);
        $output = [];
        \exec($cmd, $output);
        $basedir = $this->basedir;
        if (\is_dir($basedir) === \false) {
            $basedir = \dirname($basedir);
        }
        foreach ($output as $path) {
            $path = Util\Common::realpath($path);
            if ($path === \false) {
                // Skip deleted files.
                continue;
            }
            do {
                $modified[$path] = \true;
                $path = \dirname($path);
            } while ($path !== $basedir);
        }
        return $modified;
    }
    //end getWhitelist()
}
//end class
