<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/CoreBundle/Form/Validator/Constraints/FileEncodingValidator.php */
class __TwigTemplate_9cc4e12296e44d4202ac7b088046a9f6 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

namespace Mautic\\CoreBundle\\Form\\Validator\\Constraints;

use Symfony\\Component\\Validator\\Constraint;
use Symfony\\Component\\Validator\\ConstraintValidator;

/**
 * Throws an exception if the field alias is equal some segment filter keyword.
 * It would cause odd behavior with segment filters otherwise.
 */
class FileEncodingValidator extends ConstraintValidator
{
    /**
     * @param LeadField \$field
     */
    public function validate(\$field, Constraint \$constraint): void
    {
        /*
            If the file uploaded exceeds the max size, it will not be considered,
            and the file path will be an empty string \"\". If that is the case
            no further checks are required. Just return.
        */
        if (!\$field || '' === \$field->getPathname() || null === \$field->getPathname()) {
            return;
        }

        // Open the file in \"reading only\" mode
        \$fileHandle = fopen(\$field->getPathname(), 'rb');

        // Handler is valid or not
        if (false === \$fileHandle) {
            return;
        }

        // While we are not yet at the end of the file
        while (!feof(\$fileHandle)) {
            // Read the current line
            \$line = fgets(\$fileHandle);

            // Check for UTF-8 encoding
            if (!mb_check_encoding(\$line, 'UTF-8')) {
                \$this->context->addViolation(\$constraint->encodingFormatMessage);
            }
        }

        // Finally, close the file handle.
        fclose(\$fileHandle);
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/CoreBundle/Form/Validator/Constraints/FileEncodingValidator.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/CoreBundle/Form/Validator/Constraints/FileEncodingValidator.php", "/home/newco/public_html/up/app/bundles/CoreBundle/Form/Validator/Constraints/FileEncodingValidator.php");
    }
}
