<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/UserBundle/Security/EntryPoint/MainEntryPoint.php */
class __TwigTemplate_324e307c3142539fe6a83b9469aa0b86 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\UserBundle\\Security\\EntryPoint;

use Symfony\\Component\\HttpFoundation\\RedirectResponse;
use Symfony\\Component\\HttpFoundation\\Request;
use Symfony\\Component\\HttpFoundation\\Response;
use Symfony\\Component\\Routing\\Generator\\UrlGeneratorInterface;
use Symfony\\Component\\Security\\Core\\Exception\\AuthenticationException;
use Symfony\\Component\\Security\\Http\\EntryPoint\\AuthenticationEntryPointInterface;

class MainEntryPoint implements AuthenticationEntryPointInterface
{
    public function __construct(private UrlGeneratorInterface \$urlGenerator, private bool \$samlEnabled)
    {
    }

    public function start(Request \$request, ?AuthenticationException \$authException = null): Response
    {
        // as per https://docs.mautic.org/en/5.x/authentication/authentication.html#logging-in
        // log in always as SAML for all requests.
        // todo: task for testers: enable saml, and check if regular login page is available
        \$route = (string) \$request->attributes->get('_route');
        if (\$this->samlEnabled && 'login' !== \$route && 'mautic_user_logincheck' !== \$route) {
            // As the system doesn't know the IDP of the service, we can spare one redirect,
            // and redirect the user straight to discovery.
            return new RedirectResponse(\$this->urlGenerator->generate('lightsaml_sp.discovery'));
        }

        return new RedirectResponse(\$this->urlGenerator->generate('login'));
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/UserBundle/Security/EntryPoint/MainEntryPoint.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/UserBundle/Security/EntryPoint/MainEntryPoint.php", "/home/newco/public_html/up/app/bundles/UserBundle/Security/EntryPoint/MainEntryPoint.php");
    }
}
