<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/UserBundle/DependencyInjection/Compiler/SsoAuthenticatorPass.php */
class __TwigTemplate_9044803790db8a827285d31529df9236 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\UserBundle\\DependencyInjection\\Compiler;

use Symfony\\Component\\DependencyInjection\\Compiler\\CompilerPassInterface;
use Symfony\\Component\\DependencyInjection\\ContainerBuilder;
use Symfony\\Component\\DependencyInjection\\Exception\\InvalidArgumentException;
use Symfony\\Component\\DependencyInjection\\Exception\\ServiceNotFoundException;

/**
 * This will replace \$options in the
 * \\Mautic\\UserBundle\\DependencyInjection\\Firewall\\Factory\\MauticSsoFactory::createAuthenticator.
 */
class SsoAuthenticatorPass implements CompilerPassInterface
{
    public function process(ContainerBuilder \$container): void
    {
        \$ssoAuthenticatorId = 'security.authenticator.mautic_sso.main';
        if (!\$container->hasDefinition(\$ssoAuthenticatorId)) {
            throw new ServiceNotFoundException(\$ssoAuthenticatorId);
        }

        \$formLoginAuthenticatorId = 'security.authenticator.form_login.main';
        if (!\$container->hasDefinition(\$formLoginAuthenticatorId)) {
            throw new ServiceNotFoundException(\$formLoginAuthenticatorId);
        }

        \$loginFormAuthenticator = \$container->getDefinition(\$formLoginAuthenticatorId);
        \$formLoginOptions       = \$loginFormAuthenticator->getArgument(4);

        if (!is_array(\$formLoginOptions)) {
            throw new InvalidArgumentException('The \$options parameter must be an array. Maybe Symfony moved the parameter for the \"form_login\"?');
        }

        \$container->getDefinition(\$ssoAuthenticatorId)
            ->replaceArgument('\$options', \$formLoginOptions);
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/UserBundle/DependencyInjection/Compiler/SsoAuthenticatorPass.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/UserBundle/DependencyInjection/Compiler/SsoAuthenticatorPass.php", "/home/newco/public_html/up/app/bundles/UserBundle/DependencyInjection/Compiler/SsoAuthenticatorPass.php");
    }
}
