<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/CoreBundle/EventListener/UUIDListener.php */
class __TwigTemplate_8fb0c932377b5470da56c838e3fcdf05 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\CoreBundle\\EventListener;

use Doctrine\\Common\\EventSubscriber;
use Doctrine\\ORM\\EntityManagerInterface;
use Doctrine\\ORM\\Events;
use Doctrine\\Persistence\\Event\\LifecycleEventArgs;
use Mautic\\CoreBundle\\Entity\\UuidInterface;
use Ramsey\\Uuid\\Uuid;

class UUIDListener implements EventSubscriber
{
    public function __construct(private EntityManagerInterface \$em)
    {
    }

    /**
     * @return mixed[]
     */
    public function getSubscribedEvents(): array
    {
        return [
            Events::prePersist,
        ];
    }

    /**
     * Populate `uuid` column in `prePersist` event if the Entity is desired to have a uuid.
     *
     * @throws \\Exception
     */
    public function prePersist(LifecycleEventArgs \$args): void
    {
        \$object = \$args->getObject();

        if (false === \$object instanceof UuidInterface) {
            return;
        }

        \$this->updateDuplicateUUID(\$object);

        if (empty(\$object->getUuid())) {
            \$object->setUuid((string) Uuid::uuid4());
        }
    }

    /**
     * Resets the UUID of an entity if that entity is new.
     *
     * @throws \\Exception
     */
    private function updateDuplicateUUID(object \$object): void
    {
        if (empty(\$object->getUuid()) || (method_exists(\$object::class, 'getId') && null !== \$object->getId())) {
            return;
        }

        \$entityExists = \$this->em->getRepository(\$object::class)->findBy([
            'uuid' => \$object->getUuid(),
        ]);

        if (\$entityExists) {
            \$object->setUuid((string) Uuid::uuid4());
        }
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/CoreBundle/EventListener/UUIDListener.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/CoreBundle/EventListener/UUIDListener.php", "/home/newco/public_html/up/app/bundles/CoreBundle/EventListener/UUIDListener.php");
    }
}
