<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/NotificationBundle/EventListener/SearchSubscriber.php */
class __TwigTemplate_4dac7e9f6aa5879f2717e6c6369814de extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\NotificationBundle\\EventListener;

use Mautic\\CoreBundle\\CoreEvents;
use Mautic\\CoreBundle\\DTO\\GlobalSearchFilterDTO;
use Mautic\\CoreBundle\\Event as MauticEvents;
use Mautic\\CoreBundle\\Service\\GlobalSearch;
use Mautic\\NotificationBundle\\Model\\NotificationModel;
use Symfony\\Component\\EventDispatcher\\EventSubscriberInterface;

class SearchSubscriber implements EventSubscriberInterface
{
    public function __construct(
        private NotificationModel \$model,
        private GlobalSearch \$globalSearch,
    ) {
    }

    public static function getSubscribedEvents(): array
    {
        return [
            CoreEvents::GLOBAL_SEARCH => [
                ['onGlobalSearchWebNotification', 0],
                ['onGlobalSearchMobileNotification', 0],
            ],
        ];
    }

    public function onGlobalSearchWebNotification(MauticEvents\\GlobalSearchEvent \$event): void
    {
        \$filterDTO = new GlobalSearchFilterDTO(\$event->getSearchString());
        \$filterDTO->setFilters([
            'where'  => [
                [
                    'expr' => 'eq',
                    'col'  => 'mobile',
                    'val'  => 0,
                ],
            ],
        ]);
        \$results = \$this->globalSearch->performSearch(
            \$filterDTO,
            \$this->model,
            '@MauticNotification/SubscribedEvents/Search/global-web.html.twig'
        );

        if (!empty(\$results)) {
            \$event->addResults('mautic.notification.notification.header', \$results);
        }
    }

    public function onGlobalSearchMobileNotification(MauticEvents\\GlobalSearchEvent \$event): void
    {
        \$filterDTO = new GlobalSearchFilterDTO(\$event->getSearchString());
        \$filterDTO->setFilters([
            'where'  => [
                [
                    'expr' => 'eq',
                    'col'  => 'mobile',
                    'val'  => 1,
                ],
            ],
        ]);
        \$results = \$this->globalSearch->performSearch(
            \$filterDTO,
            \$this->model,
            '@MauticNotification/SubscribedEvents/Search/global-mobile.html.twig'
        );

        if (!empty(\$results)) {
            \$event->addResults('mautic.notification.mobile_notification.header', \$results);
        }
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/NotificationBundle/EventListener/SearchSubscriber.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/NotificationBundle/EventListener/SearchSubscriber.php", "/home/newco/public_html/up/app/bundles/NotificationBundle/EventListener/SearchSubscriber.php");
    }
}
