<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/CoreBundle/Factory/MauticFactory.php */
class __TwigTemplate_9eabb69da17a3eb7be45bdf53f0fc0bd extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

namespace Mautic\\CoreBundle\\Factory;

use Doctrine\\ORM\\EntityManager;
use Doctrine\\Persistence\\ManagerRegistry;
use Mautic\\CoreBundle\\Entity\\IpAddress;
use Mautic\\CoreBundle\\Exception\\FileNotFoundException;
use Mautic\\CoreBundle\\Helper\\DateTimeHelper;
use Mautic\\CoreBundle\\Helper\\UserHelper;
use Mautic\\CoreBundle\\Model\\AbstractCommonModel;
use Mautic\\CoreBundle\\Security\\Permissions\\CorePermissions;
use Mautic\\CoreBundle\\Translation\\Translator;
use Mautic\\EmailBundle\\Helper\\MailHelper;
use Mautic\\UserBundle\\Entity\\User;
use Symfony\\Bundle\\FrameworkBundle\\Routing\\Router;
use Symfony\\Component\\DependencyInjection\\ContainerInterface;
use Symfony\\Component\\EventDispatcher\\EventDispatcherInterface;
use Symfony\\Component\\HttpFoundation\\Request;
use Symfony\\Component\\HttpFoundation\\RequestStack;
use Symfony\\Component\\Security\\Core\\Authorization\\AuthorizationCheckerInterface;

/**
 * @deprecated 2.0 to be removed in 3.0
 */
class MauticFactory
{
    /**
     * @param ModelFactory<object> \$modelFactory
     */
    public function __construct(
        private ContainerInterface \$container,
        private ModelFactory \$modelFactory,
        private CorePermissions \$security,
        private AuthorizationCheckerInterface \$authorizationChecker,
        private UserHelper \$userHelper,
        private RequestStack \$requestStack,
        private ManagerRegistry \$doctrine,
        private Translator \$translator
    ) {
    }

    /**
     * Get a model instance from the service container.
     *
     * @return AbstractCommonModel<object>
     *
     * @throws \\InvalidArgumentException
     */
    public function getModel(\$modelNameKey): \\Mautic\\CoreBundle\\Model\\MauticModelInterface
    {
        return \$this->modelFactory->getModel(\$modelNameKey);
    }

    /**
     * Retrieves Mautic's security object.
     *
     * @return CorePermissions
     */
    public function getSecurity()
    {
        return \$this->security;
    }

    /**
     * Retrieves Symfony's security context.
     */
    public function getSecurityContext(): AuthorizationCheckerInterface
    {
        return \$this->authorizationChecker;
    }

    /**
     * Retrieves user currently logged in.
     *
     * @param bool \$nullIfGuest
     *
     * @return User|null
     */
    public function getUser(\$nullIfGuest = false)
    {
        return \$this->userHelper->getUser(\$nullIfGuest);
    }

    /**
     * Retrieves Doctrine EntityManager.
     *
     * @return EntityManager
     */
    public function getEntityManager()
    {
        \$manager = \$this->doctrine->getManager();
        \\assert(\$manager instanceof EntityManager);

        return \$manager;
    }

    /**
     * Retrieves Doctrine database connection for DBAL use.
     *
     * @return \\Doctrine\\DBAL\\Connection
     */
    public function getDatabase()
    {
        return \$this->doctrine->getConnection();
    }

    /**
     * Retrieves Translator.
     *
     * @return Translator
     */
    public function getTranslator()
    {
        if (defined('IN_MAUTIC_CONSOLE')) {
            \$translator = \$this->translator;

            \$translator->setLocale(
                \$this->getParameter('locale')
            );

            return \$translator;
        }

        return \$this->translator;
    }

    /**
     * Retrieves twig service.
     *
     * @return \\Twig\\Environment
     */
    public function getTwig()
    {
        return \$this->container->get('twig');
    }

    /**
     * Retrieves event dispatcher.
     *
     * @return EventDispatcherInterface
     */
    public function getDispatcher()
    {
        return \$this->container->get('event_dispatcher');
    }

    /**
     * Retrieves request.
     *
     * @return Request|null
     */
    public function getRequest()
    {
        \$request = \$this->requestStack->getCurrentRequest();
        if (empty(\$request)) {
            // likely in a test as the request is not populated for outside the container
            \$request      = Request::createFromGlobals();
            \$requestStack = new RequestStack();
            \$requestStack->push(\$request);
        }

        return \$request;
    }

    /**
     * Retrieves a Mautic parameter.
     *
     * @param mixed \$default
     *
     * @return bool|mixed
     */
    public function getParameter(\$id, \$default = false)
    {
        return \$this->container->get('mautic.helper.core_parameters')->get(\$id, \$default);
    }

    /**
     * Get DateTimeHelper.
     *
     * @param string \$string
     * @param string \$format
     * @param string \$tz
     */
    public function getDate(\$string = null, \$format = null, \$tz = 'local'): DateTimeHelper
    {
        return new DateTimeHelper(\$string, \$format, \$tz);
    }

    /**
     * Get Router.
     *
     * @return Router
     */
    public function getRouter()
    {
        return \$this->container->get('router');
    }

    /**
     * Get the path to specified area.  Returns relative by default with the exception of cache and log
     * which will be absolute regardless of \$fullPath setting.
     *
     * @param string \$name
     * @param bool   \$fullPath
     *
     * @return string
     *
     * @throws \\InvalidArgumentException
     */
    public function getSystemPath(\$name, \$fullPath = false)
    {
        return \$this->container->get('mautic.helper.paths')->getSystemPath(\$name, \$fullPath);
    }

    /**
     * Returns local config file path.
     *
     * @param bool \$checkExists If true, returns false if file doesn't exist
     */
    public function getLocalConfigFile(\$checkExists = true): string
    {
        /** @var \\AppKernel \$kernel */
        \$kernel = \$this->container->get('kernel');

        return \$kernel->getLocalConfigFile();
    }

    /**
     * Get the current environment.
     *
     * @return string
     */
    public function getEnvironment()
    {
        return \$this->container->getParameter('kernel.environment');
    }

    /**
     * Returns if Symfony is in debug mode.
     *
     * @return mixed
     */
    public function getDebugMode()
    {
        return \$this->container->getParameter('kernel.debug');
    }

    /**
     * returns a ThemeHelper instance for the given theme.
     *
     * @param string \$theme
     * @param bool   \$throwException
     *
     * @return mixed
     *
     * @throws FileNotFoundException
     * @throws \\Exception
     */
    public function getTheme(\$theme = 'current', \$throwException = false)
    {
        return \$this->container->get('mautic.helper.theme')->getTheme(\$theme, \$throwException);
    }

    /**
     * Gets a list of installed themes.
     *
     * @param string \$specificFeature limits list to those that support a specific feature
     * @param bool   \$extended        returns extended information about the themes
     *
     * @return array
     */
    public function getInstalledThemes(\$specificFeature = 'all', \$extended = false)
    {
        return \$this->container->get('mautic.helper.theme')->getInstalledThemes(\$specificFeature, \$extended);
    }

    /**
     * Returns MailHelper wrapper for Email via \$helper->message.
     *
     * @param bool \$cleanSlate False to preserve current settings, i.e. to process batched emails
     *
     * @return MailHelper
     */
    public function getMailer(\$cleanSlate = true)
    {
        return \$this->container->get('mautic.helper.mailer')->getMailer(\$cleanSlate);
    }

    /**
     * Guess the IP address from current session.
     *
     * @return string
     */
    public function getIpAddressFromRequest()
    {
        return \$this->container->get('mautic.helper.ip_lookup')->getIpAddressFromRequest();
    }

    /**
     * Get an IpAddress entity for current session or for passed in IP address.
     *
     * @param string \$ip
     *
     * @return IpAddress
     */
    public function getIpAddress(\$ip = null)
    {
        return \$this->container->get('mautic.helper.ip_lookup')->getIpAddress(\$ip);
    }

    /**
     * Retrieves the application's version number.
     *
     * @return string
     */
    public function getVersion()
    {
        return \$this->container->get('kernel')->getVersion();
    }

    /**
     * Get Symfony's logger.
     *
     * @param bool|false \$system
     *
     * @return \\Monolog\\Logger
     */
    public function getLogger(\$system = false)
    {
        if (\$system) {
            return \$this->container->get('logger');
        } else {
            return \$this->container->get('monolog.logger.mautic');
        }
    }

    /**
     * Get a mautic helper service.
     *
     * @return object
     */
    public function getHelper(\$helper)
    {
        return match (\$helper) {
            'template.assets'     => \$this->container->get('twig.helper.assets'),
            'template.slots'      => \$this->container->get('twig.helper.slots'),
            'template.form'       => \$this->container->get('twig.helper.form'),
            'template.translator' => \$this->container->get('twig.helper.translator'),
            'template.router'     => \$this->container->get('twig.helper.router'),
            default               => \$this->container->get('mautic.helper.'.\$helper),
        };
    }

    /**
     * Get's the Symfony kernel.
     *
     * @return \\AppKernel
     */
    public function getKernel()
    {
        return \$this->container->get('kernel');
    }

    /**
     * Get's an array of details for Mautic core bundles.
     *
     * @param bool|false \$includePlugins
     *
     * @return array|mixed
     */
    public function getMauticBundles(\$includePlugins = false)
    {
        return \$this->container->get('mautic.helper.bundle')->getMauticBundles(\$includePlugins);
    }

    /**
     * Get's an array of details for enabled Mautic plugins.
     *
     * @return array
     */
    public function getPluginBundles()
    {
        return \$this->container->get('mautic.helper.bundle')->getPluginBundles();
    }

    /**
     * Gets an array of a specific bundle's config settings.
     *
     * @param string \$configKey
     * @param bool   \$includePlugins
     *
     * @return mixed
     *
     * @throws \\Exception
     */
    public function getBundleConfig(\$bundleName, \$configKey = '', \$includePlugins = false)
    {
        return \$this->container->get('mautic.helper.bundle')->getBundleConfig(\$bundleName, \$configKey, \$includePlugins);
    }

    /**
     * @return bool
     */
    public function serviceExists(\$service)
    {
        return \$this->container->has(\$service);
    }

    /**
     * @param string \$service
     *
     * @return object|bool
     */
    public function get(\$service)
    {
        if (\$this->serviceExists(\$service)) {
            return \$this->container->get(\$service);
        }

        return false;
    }
}
";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName()
    {
        return "@bundles/CoreBundle/Factory/MauticFactory.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/CoreBundle/Factory/MauticFactory.php", "/home/newco/public_html/up/app/bundles/CoreBundle/Factory/MauticFactory.php");
    }
}
