<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/CampaignBundle/Controller/AjaxController.php */
class __TwigTemplate_b042c4092f486d175e38154041117654 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

namespace Mautic\\CampaignBundle\\Controller;

use Doctrine\\Persistence\\ManagerRegistry;
use Mautic\\CampaignBundle\\Entity\\LeadEventLog;
use Mautic\\CampaignBundle\\Model\\EventLogModel;
use Mautic\\CoreBundle\\Controller\\AjaxController as CommonAjaxController;
use Mautic\\CoreBundle\\Factory\\MauticFactory;
use Mautic\\CoreBundle\\Factory\\ModelFactory;
use Mautic\\CoreBundle\\Helper\\CoreParametersHelper;
use Mautic\\CoreBundle\\Helper\\InputHelper;
use Mautic\\CoreBundle\\Helper\\UserHelper;
use Mautic\\CoreBundle\\Security\\Permissions\\CorePermissions;
use Mautic\\CoreBundle\\Service\\FlashBag;
use Mautic\\CoreBundle\\Translation\\Translator;
use Mautic\\CoreBundle\\Twig\\Helper\\DateHelper;
use Symfony\\Component\\EventDispatcher\\EventDispatcherInterface;
use Symfony\\Component\\HttpFoundation\\Request;
use Symfony\\Component\\HttpFoundation\\RequestStack;

class AjaxController extends CommonAjaxController
{
    public function __construct(
        private DateHelper \$dateHelper,
        ManagerRegistry \$doctrine,
        MauticFactory \$factory,
        ModelFactory \$modelFactory,
        UserHelper \$userHelper,
        CoreParametersHelper \$coreParametersHelper,
        EventDispatcherInterface \$dispatcher,
        Translator \$translator,
        FlashBag \$flashBag,
        RequestStack \$requestStack,
        CorePermissions \$security
    ) {
        parent::__construct(\$doctrine, \$factory, \$modelFactory, \$userHelper, \$coreParametersHelper, \$dispatcher, \$translator, \$flashBag, \$requestStack, \$security);
    }

    public function updateConnectionsAction(Request \$request): \\Symfony\\Component\\HttpFoundation\\JsonResponse
    {
        \$session        = \$request->getSession();
        \$campaignId     = InputHelper::clean(\$request->query->get('campaignId'));
        \$canvasSettings = \$request->request->get('canvasSettings') ?? [];
        if (empty(\$campaignId)) {
            \$dataArray = ['success' => 0];
        } else {
            \$session->set('mautic.campaign.'.\$campaignId.'.events.canvassettings', \$canvasSettings);

            \$dataArray = ['success' => 1];
        }

        return \$this->sendJsonResponse(\$dataArray);
    }

    public function updateScheduledCampaignEventAction(Request \$request): \\Symfony\\Component\\HttpFoundation\\JsonResponse
    {
        \$eventId      = (int) \$request->request->get('eventId');
        \$contactId    = (int) \$request->request->get('contactId');
        \$newDate      = InputHelper::clean(\$request->request->get('date'));
        \$originalDate = InputHelper::clean(\$request->request->get('originalDate'));

        \$dataArray = ['success' => 0, 'date' => \$originalDate];

        if (!empty(\$eventId) && !empty(\$contactId) && !empty(\$newDate)) {
            if (\$log = \$this->getContactEventLog(\$eventId, \$contactId)) {
                \$newDate = new \\DateTime(\$newDate);

                if (\$newDate >= new \\DateTime()) {
                    \$log->setTriggerDate(\$newDate);

                    /** @var EventLogModel \$logModel */
                    \$logModel = \$this->getModel('campaign.event_log');
                    \$logModel->saveEntity(\$log);

                    \$dataArray = [
                        'success' => 1,
                        'date'    => \$newDate->format('Y-m-d H:i:s'),
                    ];
                }
            }
        }

        // Format the date to match the view
        \$dataArray['formattedDate'] = \$this->dateHelper->toFull(\$dataArray['date']);

        return \$this->sendJsonResponse(\$dataArray);
    }

    public function cancelScheduledCampaignEventAction(Request \$request): \\Symfony\\Component\\HttpFoundation\\JsonResponse
    {
        \$dataArray = ['success' => 0];

        \$eventId   = (int) \$request->request->get('eventId');
        \$contactId = (int) \$request->request->get('contactId');
        if (!empty(\$eventId) && !empty(\$contactId)) {
            if (\$log = \$this->getContactEventLog(\$eventId, \$contactId)) {
                \$log->setIsScheduled(false);

                /** @var EventLogModel \$logModel */
                \$logModel           = \$this->getModel('campaign.event_log');
                \$metadata           = \$log->getMetadata();
                \$metadata['errors'] = \$this->translator->trans(
                    'mautic.campaign.event.cancelled.time',
                    ['%date%' => \$log->getTriggerDate()->format('Y-m-d H:i:s')]
                );
                \$log->setMetadata(\$metadata);
                \$logModel->getRepository()->saveEntity(\$log);

                \$dataArray = ['success' => 1];
            }
        }

        return \$this->sendJsonResponse(\$dataArray);
    }

    /**
     * @return LeadEventLog|null
     */
    protected function getContactEventLog(\$eventId, \$contactId)
    {
        \$contact = \$this->getModel('lead')->getEntity(\$contactId);
        if (\$contact) {
            if (\$this->security->hasEntityAccess('lead:leads:editown', 'lead:leads:editother', \$contact->getPermissionUser())) {
                /** @var EventLogModel \$logModel */
                \$logModel = \$this->getModel('campaign.event_log');

                /** @var LeadEventLog \$log */
                \$log = \$logModel->getRepository()
                                ->findOneBy(
                                    [
                                        'lead'  => \$contactId,
                                        'event' => \$eventId,
                                    ],
                                    ['dateTriggered' => 'desc']
                                );

                if (\$log && (\$log->getTriggerDate() > new \\DateTime())) {
                    return \$log;
                }
            }
        }

        return null;
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/CampaignBundle/Controller/AjaxController.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/CampaignBundle/Controller/AjaxController.php", "/home/newco/public_html/up/app/bundles/CampaignBundle/Controller/AjaxController.php");
    }
}
