<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/LeadBundle/Command/SegmentStatCommand.php */
class __TwigTemplate_e7c0f7de030b35e8262655b7b24ddc9c extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\LeadBundle\\Command;

use Mautic\\CoreBundle\\Command\\ModeratedCommand;
use Mautic\\CoreBundle\\Helper\\CoreParametersHelper;
use Mautic\\CoreBundle\\Helper\\PathsHelper;
use Mautic\\LeadBundle\\Event\\GetStatDataEvent;
use Symfony\\Component\\Console\\Command\\Command;
use Symfony\\Component\\Console\\Input\\InputInterface;
use Symfony\\Component\\Console\\Output\\OutputInterface;
use Symfony\\Component\\Console\\Style\\SymfonyStyle;
use Symfony\\Component\\EventDispatcher\\EventDispatcherInterface;

final class SegmentStatCommand extends ModeratedCommand
{
    public function __construct(
        private EventDispatcherInterface \$dispatcher,
        PathsHelper \$pathsHelper,
        CoreParametersHelper \$coreParametersHelper,
    ) {
        parent::__construct(\$pathsHelper, \$coreParametersHelper);
    }

    protected function configure(): void
    {
        \$this
            ->setName('mautic:segments:stat')
            ->setDescription('Gather Segment Statistics');

        parent::configure();
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(InputInterface \$input, OutputInterface \$output): int
    {
        \$io         = new SymfonyStyle(\$input, \$output);
        \$event      = new GetStatDataEvent();
        \$this->dispatcher->dispatch(\$event);

        if (empty(\$event->getResults())) {
            \$io->write('There is no segment to show!!');
        } else {
            \$io->table([
                'Title',
                'Id',
                'IsPublished',
                'IsUsed',
            ],
                \$event->getResults()
            );
        }

        return Command::SUCCESS;
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/LeadBundle/Command/SegmentStatCommand.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/LeadBundle/Command/SegmentStatCommand.php", "/home/newco/public_html/up/app/bundles/LeadBundle/Command/SegmentStatCommand.php");
    }
}
