<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/MessengerBundle/MessageHandler/RemoveReportAttachmentHandler.php */
class __TwigTemplate_9621e3e00b9016f05f65665c529efd54 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\MessengerBundle\\MessageHandler;

use Mautic\\CoreBundle\\Helper\\FilePathResolver;
use Mautic\\ReportBundle\\Model\\ExportHandler;
use Symfony\\Component\\Mailer\\Messenger\\SendEmailMessage;
use Symfony\\Component\\Messenger\\Attribute\\AsMessageHandler;
use Symfony\\Component\\Mime\\Email;

#[AsMessageHandler(priority: -1000)]
class RemoveReportAttachmentHandler
{
    public function __construct(private ExportHandler \$exportHandler, private FilePathResolver \$filePathResolver)
    {
    }

    public function __invoke(SendEmailMessage \$message): void
    {
        \$email = \$message->getMessage();

        if (!\$email instanceof Email) {
            return;
        }

        \$attachments = \$email->getAttachments();

        foreach (\$attachments as \$attachment) {
            \$headers = \$attachment->getPreparedHeaders();
            if (!\$headers->has('Content-Disposition')) {
                continue;
            }

            \$filename = \$headers->getHeaderParameter('Content-Disposition', 'filename');
            if (null === \$filename) {
                continue;
            }

            \$attachmentPath = \$this->exportHandler->getPath(pathinfo(\$filename, \\PATHINFO_FILENAME));

            \$this->filePathResolver->delete(\$attachmentPath);
            // str_replace as in \\Mautic\\ReportBundle\\Scheduler\\Model\\FileHandler::zipIt
            \$this->filePathResolver->delete(str_replace('.csv', '.zip', \$attachmentPath));
        }
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/MessengerBundle/MessageHandler/RemoveReportAttachmentHandler.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/MessengerBundle/MessageHandler/RemoveReportAttachmentHandler.php", "/home/newco/public_html/up/app/bundles/MessengerBundle/MessageHandler/RemoveReportAttachmentHandler.php");
    }
}
