<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/WebhookBundle/Http/Client.php */
class __TwigTemplate_cd7f9cc5a51aef2eb06153ca798d04dd extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

namespace Mautic\\WebhookBundle\\Http;

use GuzzleHttp\\Client as GuzzleClient;
use GuzzleHttp\\Psr7\\Request;
use Mautic\\CoreBundle\\Helper\\CoreParametersHelper;
use Mautic\\CoreBundle\\Helper\\PrivateAddressChecker;
use Mautic\\WebhookBundle\\Exception\\PrivateAddressException;
use Psr\\Http\\Message\\ResponseInterface;

class Client
{
    public function __construct(
        private CoreParametersHelper \$coreParametersHelper,
        private GuzzleClient \$httpClient,
        private PrivateAddressChecker \$privateAddressChecker,
    ) {
    }

    /**
     * @throws \\Http\\Client\\Exception
     */
    public function post(\$url, array \$payload, string \$secret = null): ResponseInterface
    {
        \$jsonPayload = json_encode(\$payload);
        \$signature   = null === \$secret ? null : base64_encode(hash_hmac('sha256', \$jsonPayload, \$secret, true));
        \$headers     = [
            'Content-Type'      => 'application/json',
            'X-Origin-Base-URL' => \$this->coreParametersHelper->get('site_url'),
            'Webhook-Signature' => \$signature,
        ];

        \$allowedPrivateAddresses = \$this->coreParametersHelper->get('webhook_allowed_private_addresses');
        \$this->privateAddressChecker->setAllowedPrivateAddresses(\$allowedPrivateAddresses);

        if (!\$this->privateAddressChecker->isAllowedUrl(\$url)) {
            throw new PrivateAddressException();
        }

        return \$this->httpClient->sendRequest(new Request('POST', \$url, \$headers, \$jsonPayload));
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/WebhookBundle/Http/Client.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/WebhookBundle/Http/Client.php", "/home/newco/public_html/up/app/bundles/WebhookBundle/Http/Client.php");
    }
}
