<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/UserBundle/EventListener/PasswordStrengthSubscriber.php */
class __TwigTemplate_e9295dec58ee93c9a892ed0ac7ba9368 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\UserBundle\\EventListener;

use Mautic\\UserBundle\\Security\\Authenticator\\Passport\\Badge\\PasswordStrengthBadge;
use Symfony\\Component\\EventDispatcher\\EventSubscriberInterface;
use Symfony\\Component\\Security\\Http\\Authenticator\\Passport\\Credentials\\PasswordCredentials;
use Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent;

/**
 * This must record a PW before CheckCredentialsListener will take an effect.
 * Subscriber will add a password check badge.
 */
final class PasswordStrengthSubscriber implements EventSubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            CheckPassportEvent::class => ['checkPassport', 100],
        ];
    }

    public function checkPassport(CheckPassportEvent \$event): void
    {
        \$passport = \$event->getPassport();
        if (!\$passport->hasBadge(PasswordCredentials::class)) {
            return;
        }

        \$badge = \$passport->getBadge(PasswordCredentials::class);
        \\assert(\$badge instanceof PasswordCredentials);
        \$presentedPassword = \$badge->getPassword();

        \$passport->addBadge(new PasswordStrengthBadge(\$presentedPassword));
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/UserBundle/EventListener/PasswordStrengthSubscriber.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/UserBundle/EventListener/PasswordStrengthSubscriber.php", "/home/newco/public_html/up/app/bundles/UserBundle/EventListener/PasswordStrengthSubscriber.php");
    }
}
