<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/UserBundle/EventListener/PasswordSubscriber.php */
class __TwigTemplate_5aaa13509ce8dce9e7166acf1dfd08fc extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\UserBundle\\EventListener;

use Mautic\\UserBundle\\Exception\\WeakPasswordException;
use Mautic\\UserBundle\\Model\\PasswordStrengthEstimatorModel;
use Mautic\\UserBundle\\Security\\Authenticator\\Passport\\Badge\\PasswordStrengthBadge;
use Symfony\\Component\\EventDispatcher\\EventSubscriberInterface;
use Symfony\\Component\\Security\\Core\\Exception\\BadCredentialsException;
use Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent;

final class PasswordSubscriber implements EventSubscriberInterface
{
    public function __construct(private PasswordStrengthEstimatorModel \$passwordStrengthEstimatorModel)
    {
    }

    public static function getSubscribedEvents(): array
    {
        return [
            CheckPassportEvent::class => ['checkPassport', -100], // After default password checker
        ];
    }

    public function checkPassport(CheckPassportEvent \$event): void
    {
        \$passport = \$event->getPassport();
        if (!\$passport->hasBadge(PasswordStrengthBadge::class)) {
            return;
        }

        \$badge = \$passport->getBadge(PasswordStrengthBadge::class);
        \\assert(\$badge instanceof PasswordStrengthBadge);
        \$presentedPassword = \$badge->getPresentedPassword();
        if ('' === \$presentedPassword) {
            throw new BadCredentialsException('The presented password cannot be empty.');
        }

        if (!\$this->passwordStrengthEstimatorModel->validate(\$presentedPassword)) {
            throw new WeakPasswordException();
        }

        \$badge->setResolved();
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/UserBundle/EventListener/PasswordSubscriber.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/UserBundle/EventListener/PasswordSubscriber.php", "/home/newco/public_html/up/app/bundles/UserBundle/EventListener/PasswordSubscriber.php");
    }
}
