<?php

namespace Leezy\PheanstalkBundle\Command;

use Pheanstalk\Exception;
use Pheanstalk\JobId;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class KickJobCommand extends AbstractPheanstalkCommand
{
    /**
     * @inheritdoc
     */
    protected function configure()
    {
        $this
            ->setName('leezy:pheanstalk:kick-job')
            ->addArgument('job', InputArgument::REQUIRED, 'The job id to kick.')
            ->addArgument('pheanstalk', InputArgument::OPTIONAL, 'Pheanstalk name.')
            ->setDescription('Kick the specified job if it has a valid buried status, regardless of what tube it is in.');
    }

    /**
     * @inheritdoc
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $jobId      = $input->getArgument('job');
        $name       = $input->getArgument('pheanstalk');
        $pheanstalk = $this->getPheanstalk($name);

        try {
            $pheanstalk->kickJob(new JobId($jobId));

            $output->writeln('Pheanstalk: <info>'.$name.'</info>');
            $output->writeln(sprintf('Job #%d has been kicked.', $jobId));

            return 0;
        } catch (Exception $e) {
            $output->writeln('Pheanstalk: <info>'.$name.'</info>');
            $output->writeln(sprintf('<error>%s</error>', $e->getMessage()));

            return 1;
        }
    }
}
