<?php

declare(strict_types=1);

namespace Mautic\CoreBundle\Cache;

class ResultCacheOptions
{
    /**
     * @param string  $namespace mainly used for invalidation
     * @param ?int    $ttl       in seconds
     * @param ?string $id        will be autogenerated from the query if not provided. Use only if you know what you are doing.
     */
    public function __construct(private string $namespace, private ?int $ttl = null, private ?string $id = null)
    {
    }

    public function getNamespace(): string
    {
        return $this->namespace;
    }

    public function getTtl(): ?int
    {
        return $this->ttl;
    }

    public function getId(): ?string
    {
        return $this->id;
    }
}
